 <?php
    if( have_rows('row_types') ):
        while ( have_rows('row_types') ) : the_row();

            // Case: Text with offer layout.
            if( get_row_layout() == 'text_with_offer' ): ?>
                <div class="bg_texture right-black-30">
                    <div class="container">
                        <div class="row">
                            <div class="col-12 col-lg-8 py-5">
                                <h1><?php the_sub_field('title'); ?></h1>
                            </div>

                            <div class="col-12 col-lg-4 bg_black">
                            </div>

                            <div class="col-12 col-lg-8 pb-lg-5">
                                <?php
                                if( have_rows('text') ): ?>
                                    <?php if(!isMobileDevice()): ?>
                                        <div class="row">
                                            <?php while ( have_rows('text') ) : the_row(); ?>
                                                <div class="col-12 col-lg indent-text-white pb-4 pb-lg-0">
                                                    <h3><?php the_sub_field('title'); ?></h3>
                                                    <p><?php the_sub_field('text_in_col'); ?></p>
                                                </div>
                                            <?php endwhile; ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="owl-carousel full-mob pl-4 pr-5 px-lg-4">
                                            <?php while ( have_rows('text') ) : the_row(); ?>
                                                <div class="item indent-text-white">
                                                    <h3><?php the_sub_field('title'); ?></h3>
                                                    <p><?php the_sub_field('text_in_col'); ?></p>
                                                </div>
                                            <?php endwhile; ?>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                
                                <div class="py-3 py-lg-5 row align-items-center">
                                    <div class="col-6 col-lg-3 text-center">
                                        <img class="mb-4 mb-lg-0" src="<?php the_sub_field('cta_link_image'); ?>" alt="cta image">
                                    </div>
                                    <div class="col-6 col-lg-9">
                                        <?php 
                                        $link = get_sub_field('cta_link');
                                        if( $link ): 
                                            $link_url = $link['url'];
                                            $link_title = $link['title'];
                                            $link_target = $link['target'] ? $link['target'] : '_self';
                                            ?>
                                            <div class="cta-link-g-cont d-inline-block cta-a">
                                                <a class="cta-link-g pr-lg-3" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                                                <hr class="arrow-right">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
            
                            <div class="col-12 col-lg-4 bg_black pt-5 pt-lg-0 pb-5 pb-lg-0 px-md-5">
                                <?php
                                $featured_posts = get_sub_field('offer');
                                if( $featured_posts ): ?>
                                    <div>
                                    <?php foreach( $featured_posts as $post ): 
                                        setup_postdata($post); ?>
                                        <?php
                                        $featured_post = get_sub_field('offer');
                                        if( $featured_post ): ?>
                                            <p class="red-bg-sm"><?php the_field('type_of_offer'); ?></p>
                                            <p class="mer-md"><?php the_field('intro_title'); ?></p>
                                            <p class="red-bg-lg"><?php the_title(); ?></p>
                                            <div class="d-flex align-items-center">
                                                <div class="pr-3">
                                                    <p class="small">ONLY</p>
                                                    <p><span class="price">$<?php the_field('price_inc_gst'); ?></span> <span class="small">INC GST</span></p>
                                                </div>
                                                <div>
                                                    <p class="white-circle d-flex align-items-center justify-content-center">Saves<br>$<?php the_field('saves'); ?></p>
                                                </div>
                                            </div>
                                            <p><?php the_field('disclaimer'); ?></p>
                                            <?php 
                                            $link = get_field('link');
                                            if( $link ): 
                                                $link_url = $link['url'];
                                                $link_title = $link['title'];
                                                $link_target = $link['target'] ? $link['target'] : '_self';
                                                ?>
                                                <a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                    </div>
                                    <?php 
                                    wp_reset_postdata(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

            <?php 
            // Case: Text, Image and Review.
            elseif( get_row_layout() == 'text_image_and_review' ):?>
                <div class="bg_grey">
                    <div class="container py-5">
                        <div class="row pt-lg-5">
                            <?php if ( get_sub_field('title') or get_sub_field('featured_review') ) : ?>
                                <div class="col-12 col-lg pb-5 pb-lg-0">
                                    <h1><?php the_sub_field('title'); ?></h1>
    
                                    <?php
                                    $featured_posts = get_sub_field('featured_review');
                                    if( $featured_posts ): ?>
                                        <?php foreach( $featured_posts as $post ): 
                                            setup_postdata($post); ?>
                                            <div class="py-5">
                                                <div class="r-excerpt"><?php the_excerpt(); ?></div>
                                                <p><?php the_title(); ?></p>
                                            </div>
                                        <?php endforeach; ?>
                                        <a href="<?php echo get_page_link(291); ?>" class="btn btn-red">VIEW MORE REVIEWS</a>
                                        <?php wp_reset_postdata(); ?>
                                    <?php endif; ?>
    
                                </div>
                            <?php endif; ?>
                            <?php if ( get_sub_field('image') ) : ?>
                                <div class="col-12 col-lg pb-5 pb-lg-0">
                                    <div class="px-lg-3"><img src="<?php the_sub_field('image'); ?>" alt="review row image"></div>
                                </div>
                            <?php endif; ?>
                            <?php if ( get_sub_field('text') ) : ?>
                                <div class="col-12 col-lg indent-text-black">
                                    <?php the_sub_field('text'); ?>
                                    <?php 
                                    $link = get_sub_field('link');
                                    if( $link ): 
                                        $link_url = $link['url'];
                                        $link_title = $link['title'];
                                        $link_target = $link['target'] ? $link['target'] : '_self';
                                        ?>
                                        <div class="mt-4"><a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a></div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <?php 
                // Case: Logo List.
                elseif( get_row_layout() == 'logo_list' ):?>
                <div class="bg_grey py-lg-5">
                    <div class="container b-border-t py-5">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-3">
                                <h3><?php the_sub_field('title'); ?></h3>
                            </div>
                            <div class="col-12 col-lg-9">
                                <div class="row align-items-center px-3 px-lg-0">
                                    <?php if(!isMobileDevice()): ?>
                                        <?php
                                        if( have_rows('logos') ): ?>
                                            <?php while ( have_rows('logos') ) : the_row(); ?>
                                            <div class="col-6 col-lg text-center item"><img src=" <?php the_sub_field('image'); ?>" alt="logo"></div>
                                            <?php endwhile; ?>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php
                                        if( have_rows('logos') ): ?>
                                            <div class="col-12 owl-carousel full-mob logo-list">
                                                <?php while ( have_rows('logos') ) : the_row(); ?>
                                                <div class="text-center"><img src=" <?php the_sub_field('image'); ?>" alt="logo"></div>
                                                <?php endwhile; ?>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php 
                // Case: Fixed Heading.
                elseif( get_row_layout() == 'fixed_heading_with_rows' ):?>
                <div class="bg_texture relative py-5">
                    <div class="fixed-title">
                        <?php if ( get_sub_field('fixed_title') ) : ?>
                            <h1><?php the_sub_field('fixed_title'); ?></h1>
                        <?php endif; ?>
                    </div>
                    <div class="container fixed-title-container">
                        <?php
                        if( have_rows('alternating_rows') ):
                            $count = 0;
                            while ( have_rows('alternating_rows') ) : the_row(); ?>
                                <?php if ($count % 2): ?>
                                <!-- EVEN LAYOUT -->
                                <div class="py-lg-5">
                                    <?php if(!get_sub_field('small_image') or !get_sub_field('large_image')): ?>
                                    <div class="row py-5 py-lg-5 align-items-center">
                                    <?php else: ?>
                                    <div class="row py-5 py-lg-5">
                                    <?php endif; ?>
                                        <div class="col-12 col-lg-5 indent-text-white">
                                            <div class="text-center pb-3 pb-lg-5">
                                                <?php if ( get_sub_field('title_icon') ) : ?>
                                                    <div class="pb-3"><img src="<?php the_sub_field('title_icon'); ?>" alt="title icon"></div>
                                                <?php endif; ?>
                                                <h3><?php the_sub_field('title'); ?></h3>
                                                <div class="row justify-content-center">
                                                    <div class="col-4">
                                                        <hr class="white">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="py-3"><?php the_sub_field('text'); ?></div>
                                            <?php 
                                            $link = get_sub_field('link');
                                            if( $link ): 
                                                $link_url = $link['url'];
                                                $link_title = $link['title'];
                                                $link_target = $link['target'] ? $link['target'] : '_self';
                                                ?>
                                                <div class="text-center">
                                                    <a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <?php if(!get_sub_field('small_image') or !get_sub_field('large_image')): ?>
                                        <div class="col-12 col-lg-7 pl-lg-5">
                                        <?php else: ?>
                                        <div class="col-12 col-lg-7 page-row-images pl-lg-5">
                                        <?php endif; ?>
                                            <div class="row h-100">
                                                <?php if(!get_sub_field('small_image')): ?>
                                                    <div class="col-12 p-lg-0 pt-4 bring-to-front single-image"><img src="<?php the_sub_field('large_image'); ?>" alt="large image"></div>
                                                <?php else: ?>
                                                    <div class="col-6 col-lg-7 pr-0 pt-lg-4 large-img bring-to-front"><img src="<?php the_sub_field('large_image'); ?>" alt="large image"></div>
                                                    <div class="col-6 col-lg-5 pl-0 pt-4 align-self-end small-img pt-4 pt-lg-0 bring-to-front"><img src="<?php the_sub_field('small_image'); ?>" alt="small image"></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php else: ?>
                                <!-- ODD LAYOUT -->
                                <div class="py-lg-5">
                                    <?php if(!get_sub_field('small_image') or !get_sub_field('large_image')): ?>
                                    <div class="row py-5 py-lg-5 align-items-center">
                                    <?php else: ?>
                                    <div class="row py-5 py-lg-5">
                                    <?php endif; ?>
                                        <?php if(!get_sub_field('small_image') or !get_sub_field('large_image')): ?>
                                        <div class="col-12 col-lg-7 pr-lg-5 order-2 order-lg-1">
                                        <?php else: ?>
                                        <div class="col-12 col-lg-7 page-row-images pr-lg-5 order-2 order-lg-1">
                                        <?php endif; ?>
                                            <div class="row h-100">
                                                <?php if(!get_sub_field('small_image')): ?>
                                                    <div class="col-12 p-lg-0 pb-4 bring-to-front single-image"><img src="<?php the_sub_field('large_image'); ?>" alt="large image"></div>
                                                <?php else: ?>
                                                    <div class="col-6 col-lg-7 pr-0 pb-4 large-img bring-to-front"><img src="<?php the_sub_field('large_image'); ?>" alt="large image"></div>
                                                    <div class="col-6 col-lg-5 pl-0 pb-4 align-self-end small-img pt-4 pt-lg-0 bring-to-front"><img src="<?php the_sub_field('small_image'); ?>" alt="small image"></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-12 col-lg-5 indent-text-white pl-lg-5 order-1 order-lg-2">
                                            <div class="text-center pb-3 pb-lg-5">
                                                <?php if ( get_sub_field('title_icon') ) : ?>
                                                    <div class="pb-3"><img src="<?php the_sub_field('title_icon'); ?>" alt="title icon"></div>
                                                <?php endif; ?>
                                                <h3><?php the_sub_field('title'); ?></h3>
                                                <div class="row justify-content-center">
                                                    <div class="col-4 col-lg-4">
                                                        <hr class="white">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="py-3"><?php the_sub_field('text'); ?></div>
                                            <?php 
                                            $link = get_sub_field('link');
                                            if( $link ): 
                                                $link_url = $link['url'];
                                                $link_title = $link['title'];
                                                $link_target = $link['target'] ? $link['target'] : '_self';
                                                ?>
                                                <div class="text-center">
                                                    <a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                   
                                </div>
                                <?php endif; ?>
                            <?php $count++; endwhile;
                        endif;
                        ?>
                    </div> 
                </div>   

                <?php 
                // Case: Team Members.
                elseif( get_row_layout() == 'team_members' ):?>
                <div class="bg_texture py-lg-5">
                    <div class="container py-5">
                        <div class="row">
                            <div class="col-12">
                                <?php if ( get_sub_field('title') ) : ?>
                                    <h1><?php echo get_sub_field('title'); ?></h1>
                                <?php endif; ?>
                            </div>
                            <?php
                            $featured_posts = get_sub_field('team_members');
                            if( $featured_posts ): ?>
                                <?php foreach( $featured_posts as $post ): 
                                    setup_postdata($post); ?>
                                    <div class="col-12 col-lg-6">
                                        <div class="row pb-5">
                                        </div>
                                        <div class="row">
                                            <div class="col-12 col-lg-4 text-center mb-5 mb-lg-0">
                                                <?php the_post_thumbnail(); ?>
                                            </div>
                                            <div class="col-12 col-lg-8">
                                                <h3><?php the_title(); ?></h3>
                                                <?php the_content(); ?>
                                            </div>
                                        </div>
                                        <div class="row pt-5 d-none d-lg-flex">
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                                <?php 
                                wp_reset_postdata(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <?php 
                // Case: Our Process.
                elseif( get_row_layout() == 'our_process' ):?>
                <div class="container py-5">
                    <div class="row py-lg-5">
                        <div class="col-12 col-lg-3 pb-4 intro">
                            <?php if ( get_sub_field('title') ) : ?>
                                <h1 class="mb-4"><?php echo get_sub_field('title'); ?></h1>
                            <?php endif; ?>
                            <?php if ( get_sub_field('text') ) : ?>
                                <div class="indent-text-black"><?php echo get_sub_field('text'); ?></div>
                            <?php endif; ?>
                        </div>
                        <div class="col-12 col-lg-3">
                            <?php 
                            $image = get_sub_field('image');
                            if( !empty( $image ) ): ?>
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                            <?php endif; ?>
                        </div>
                        <div class="col-12 col-lg-6">
                            <?php if(!isMobileDevice()): ?>
                            <div class="row">
                                <div class="col-12">
                                    <?php if ( get_sub_field('process_instruction') ) : ?>
                                        <p class="grey"><?php echo get_sub_field('process_instruction'); ?></p>
                                    <?php endif; ?>
                                </div>
                                <?php
                                $loop = new WP_Query( array( 'post_type' => 'our_process', 'posts_per_page' => -1 ) );
                                if ( $loop->have_posts() ) :
                                $counter = 1; ?>
                                    <div class="col-12 col-lg-5 nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                    <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                        <a class="nav-link pb-4" id="<?php global $post; echo $post->post_name; ?>-tab" data-toggle="pill" href="#<?php global $post; echo $post->post_name; ?>" role="tab" aria-controls="<?php global $post; echo $post->post_name; ?>" aria-selected="true">
                                            <div class="d-flex align-items-center">
                                                <div>
                                                    <div class="process-number d-flex align-items-center justify-content-center">
                                                        <p><?php echo $counter;?></p>
                                                    </div>
                                                </div>
                                                <div class="nav-link-title pl-3">
                                                    <p><?php the_title(); ?></p>
                                                </div>
                                            </div>
                                        </a>
                                    <?php $counter++; endwhile; ?>
                                    </div>
                                <?php endif;
                                wp_reset_postdata();
                                ?>
                                <?php
                                $loop = new WP_Query( array( 'post_type' => 'our_process', 'posts_per_page' => -1 ) );
                                if ( $loop->have_posts() ) : ?>
                                    <div class="col-12 col-lg-7 tab-content pl-lg-5" id="v-pills-tabContent">
                                        <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                        <div class="tab-pane fade" id="<?php global $post; echo $post->post_name; ?>" role="tabpanel" aria-labelledby="<?php global $post; echo $post->post_name; ?>">
                                            <?php the_content(); ?>
                                        </div>
                                    <?php endwhile; ?>
                                    </div>
                                <?php endif;
                                wp_reset_postdata();
                                ?>
                            </div>
                            <?php else: ?>
                            <!-- MOBILE ACCORDION -->
                            <div class="row py-5">
                                <div class="col-12">
                                    <?php
                                    $loop = new WP_Query( array( 'post_type' => 'our_process', 'posts_per_page' => -1 ) );
                                    if ( $loop->have_posts() ) : 
                                        $counter = 1;?>
                                        <div id="accordion">
                                            <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                            <div class="card">
                                                <div class="card-header row align-items-center" id="headingOne" data-toggle="collapse" data-target="#acc-<?php global $post; echo $post->post_name; ?>" aria-expanded="false" aria-controls="acc-<?php global $post; echo $post->post_name; ?>">
                                                    <div class="col-2">
                                                        <div class="process-number d-flex align-items-center justify-content-center">
                                                            <p><?php echo $counter;?></p>
                                                        </div>
                                                    </div>
                                                    <div class="col-10">
                                                        <h3 class="mb-0 pl-3"><?php the_title(); ?></h3>
                                                    </div>
                                                </div>

                                                <div id="acc-<?php global $post; echo $post->post_name; ?>" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
                                                    <div class="card-body">
                                                        <?php the_content(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php $counter++; endwhile; ?>
                                        </div>
                                    <?php endif;
                                    wp_reset_postdata();
                                    ?>

                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <?php 
                // Case: Service Details (Single).
                elseif( get_row_layout() == 'service_details_single' ):?>
                <div class="container py-5">
                    <div class="row py-lg-5 intro">
                        <?php if ( get_sub_field('main_title') or get_sub_field('text') ) : ?>
                            <div class="col-12 col-lg indent-text-black pb-5 pb-lg-0">
                                <?php if ( get_sub_field('main_title') ) : ?>
                                    <h1><?php echo get_sub_field('main_title'); ?></h1>
                                <?php endif; ?>
                                <?php if ( get_sub_field('text') ) : ?>
                                    <?php echo get_sub_field('text'); ?>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if ( get_sub_field('image') ) : ?>
                            <div class="col-12 col-lg pb-5 pb-lg-0">
                                <div class="px-lg-2">
                                    <?php 
                                    $imageservice = get_sub_field('image');
                                    if( !empty( $imageservice ) ): ?>
                                        <img src="<?php echo esc_url($imageservice['url']); ?>" alt="<?php echo esc_attr($imageservice['alt']); ?>" />
                                    <?php endif; ?>  
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if ( get_sub_field('text_right') ) : ?>
                            <div class="col-12 col-lg">
                                <div class="row pt-lg-3">
                                    <?php if ( get_sub_field('column_3_title') ) : ?>
                                    <div class="col-12 mb-3">
                                        <h3><?php echo get_sub_field('column_3_title'); ?></h3>
                                    </div>
                                    <?php endif; ?>
                                    <div class="col-12 col-lg">
                                        <?php echo get_sub_field('text_right'); ?>
                                    </div>
                                    <?php if ( get_sub_field('text_right_50') ) : ?>
                                    <div class="col-12 col-lg">
                                        <?php echo get_sub_field('text_right_50'); ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <?php 
                // Case: Pricing Tabs.
                elseif( get_row_layout() == 'pricing_tabs' ):?>

                <div class="bg_texture pb-lg-5">
                    <div class="container py-5">
                       <div class="row align-items-center">
                            <?php if ( get_sub_field('title') or get_sub_field('text') ) : ?>
                                <div class="col-12 col-lg-4 indent-text-white">
                                    <h1 class="mb-4"><?php echo get_sub_field('title'); ?></h1>
                                    <?php echo get_sub_field('text'); ?>
                                </div>
                            <?php endif; ?>
                            <div class="col-12 col-lg-8 pl-lg-5 pt-5 pt-lg-0">

                            <?php
                            $loop = new WP_Query( array( 'post_type' => 'services', 'posts_per_page' => -1 ) );
                            if ( $loop->have_posts() ) : ?>
                            <ul class="row nav nav-pills pb-5 pb-lg-0" id="pills-tab" role="tablist">
                                <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                    <li class="col-12 col-lg nav-item p-0">
                                        <a class="nav-link align-items-center d-lg-flex h-100" id="<?php global $post; echo $post->post_name; ?>-tab" data-toggle="pill" href="#<?php global $post; echo $post->post_name; ?>" role="tab" aria-controls="<?php global $post; echo $post->post_name; ?>" aria-selected="false"><?php the_title(); ?></a>
                                    </li>
                                <?php endwhile; ?>
                            </ul>
                            <?php endif;
                            wp_reset_postdata();
                            ?>

                            <div class="row pricing-tab-content">
                                <div>
                                    <?php
                                    $loop = new WP_Query( array( 'post_type' => 'services', 'posts_per_page' => -1 ) );
                                    if ( $loop->have_posts() ) : ?>
                                    <div class="tab-content bg_white py-5" id="pills-tabContent">
                                        <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                            <div class="tab-pane fade" id="<?php global $post; echo $post->post_name; ?>" role="tabpanel" aria-labelledby="<?php global $post; echo $post->post_name; ?>-tab">
                                            
                                            <?php
                                            if( have_rows('pricing') ): ?>
                                            <div class="container">
                                                <div class="row justify-contnet-center">
                                                    <?php while ( have_rows('pricing') ) : the_row(); ?>
                                                    <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                                                        <?php 
                                                        $image = get_sub_field('icon');
                                                        if( !empty( $image ) ): ?>
                                                            <div class="mb-4"><img class="pricing-icon" src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" /></div>
                                                        <?php endif; ?>
                                                        <?php if ( get_sub_field('title') ) : ?>
                                                            <p class="price-title"><?php echo get_sub_field('title'); ?></p>
                                                        <?php endif; ?>
                                                        <?php if ( get_sub_field('price') ) : ?>
                                                            <p class="price-number"><?php echo get_sub_field('price'); ?></p>
                                                        <?php endif; ?>
                                                        <?php if ( get_sub_field('details') ) : ?>
                                                            <p><?php echo get_sub_field('details'); ?></p>
                                                        <?php endif; ?>
                                                        
                                                    </div>
                                                    <?php endwhile; ?>
                                                </div>
                                            </div>
                                            <?php elseif(get_field('type_1_price') or get_field('type_2_price') or get_field('type_3_price') or get_field('type_4_price') or get_field('type_5_price')): ?>
                                            <div class="container">
                                                <div class="row justify-content-center">
        
                                                    <?php if(get_field('type_1_price')): ?>
                                                    <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                                                        <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-1.png" alt="unit icon"></div>
                                                        <p class="price-title">Unit</p>
                                                        <?php if ( get_field('type_1_price') ) : ?>
                                                            <p class="price-number"><?php echo get_field('type_1_price'); ?></p>
                                                        <?php endif; ?>
                                                        <?php if ( get_field('type_1_details') ) : ?>
                                                            <p><?php echo get_field('type_1_details'); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php endif; ?>
        
                                                    <?php if(get_field('type_2_price')): ?>
                                                    <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                                                        <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-2.png" alt="unit icon"></div>
                                                        <p class="price-title">Townhouse</p>
                                                        <?php if ( get_field('type_2_price') ) : ?>
                                                            <p class="price-number"><?php echo get_field('type_2_price'); ?></p>
                                                        <?php endif; ?>
                                                        <?php if ( get_field('type_2_details') ) : ?>
                                                            <p><?php echo get_field('type_2_details'); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php endif; ?>
        
                                                    <?php if(get_field('type_3_price')): ?>
                                                    <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                                                        <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-3.png" alt="unit icon"></div>
                                                        <p class="price-title">Lowset Home</p>
                                                        <?php if ( get_field('type_3_price') ) : ?>
                                                            <p class="price-number"><?php echo get_field('type_3_price'); ?></p>
                                                        <?php endif; ?>
                                                        <?php if ( get_field('type_3_details') ) : ?>
                                                            <p><?php echo get_field('type_3_details'); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php endif; ?>
        
                                                    <?php if(get_field('type_4_price')): ?>
                                                    <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                                                        <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-4.png" alt="unit icon"></div>
                                                        <p class="price-title">Highset Home</p>
                                                        <?php if ( get_field('type_4_price') ) : ?>
                                                            <p class="price-number"><?php echo get_field('type_4_price'); ?></p>
                                                        <?php endif; ?>
                                                        <?php if ( get_field('type_4_details') ) : ?>
                                                            <p><?php echo get_field('type_4_details'); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php endif; ?>
        
                                                    <?php if(get_field('type_5_price')): ?>
                                                    <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                                                        <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-5.png" alt="unit icon"></div>
                                                        <p class="price-title">Large Home</p>
                                                        <?php if ( get_field('type_5_price') ) : ?>
                                                            <p class="price-number"><?php echo get_field('type_5_price'); ?></p>
                                                        <?php endif; ?>
                                                        <?php if ( get_field('type_5_details') ) : ?>
                                                            <p><?php echo get_field('type_5_details'); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php endif; ?>
        
                                                </div>
                                            </div>
                                            <?php  endif; ?>
                                            
                                            </div>
                                        <?php endwhile; ?>
                                    </div>
                                    <?php endif;
                                    wp_reset_postdata();
                                    ?>
                                </div>
                            </div>

                            </div>
                       </div>
                    </div>
                </div>

                <?php 
                // Case: FAQ.
                elseif( get_row_layout() == 'faq' ):?>

                <div class="bg_texture pb-lg-5">
                    <div class="container py-5">
                       <div class="row">
                            <?php if ( get_sub_field('title') or get_sub_field('text') ) : ?>
                                <div class="col-12 col-lg-4 indent-text-white">
                                    <h1 class="mb-4"><?php echo get_sub_field('title'); ?></h1>
                                    <?php echo get_sub_field('text'); ?>
                                </div>
                            <?php endif; ?>

                            <?php
                            $loop = new WP_Query( array( 'post_type' => 'faqs', 'posts_per_page' => -1 ) );
                            if ( $loop->have_posts() ) : ?>
                                <div class="col-12 col-lg-8">
                                    <div class="accordion" id="accordionExample">
                                    <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                        <div class="card">
                                            <div class="card-header d-flex justify-content-between align-items-center" id="headingOne" data-toggle="collapse" data-target="#acc-<?php global $post; echo $post->post_name; ?>" aria-expanded="false" aria-controls="acc-<?php global $post; echo $post->post_name; ?>">
                                                <p><?php the_title(); ?></p>
                                                <i class="pl-3 fas fa-chevron-down"></i>
                                            </div>

                                            <div id="acc-<?php global $post; echo $post->post_name; ?>" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample">
                                                <div class="card-body">
                                                    <?php the_content(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                    </div>
                                </div>
                            <?php endif;
                            wp_reset_postdata();
                            ?>
                        </div>
                    </div>
                </div>

                <?php 
                // Case: Reviews.
                elseif( get_row_layout() == 'reviews' ):?>
                
                <div class="bg_texture pb-lg-5">
                    <div class="container py-5">
                       <div class="row">
                            <?php if ( get_sub_field('title') or get_sub_field('text') ) : ?>
                                <div class="col-12 col-lg-4 indent-text-white mb-4 mb-lg-0">
                                    <h1 class="mb-4"><?php echo get_sub_field('title'); ?></h1>
                                    <?php echo get_sub_field('text'); ?>
                                </div>
                            <?php endif; ?>

                            <?php
                            $loop = new WP_Query( array( 'post_type' => 'reviews', 'posts_per_page' => -1 ) );
                            if ( $loop->have_posts() ) : ?>
                            <div class="col-12 col-lg-8 pl-lg-5">
                                <div class="row">
                                <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                    <div class="col-12 col-lg-6 pt-4 pt-lg-0 pb-4 pb-lg-5  d-flex justify-content-between flex-column review-service pl-lg-5">
                                        <div class="rev-excerpt">
                                            <?php the_excerpt(); ?>
                                        </div>

                                        <div>
                                            <!-- Button trigger modal -->
                                            <a class="btn-link link-arrow d-block" data-toggle="modal" data-target="#modal-<?php global $post; echo $post->post_name; ?>">
                                            Read Full Review
                                            </a>
                                            <p><?php the_title(); ?></p>
                                        </div>

                                        <!-- Modal -->
                                        <div class="modal fade" id="modal-<?php global $post; echo $post->post_name; ?>" tabindex="-1" role="dialog" aria-labelledby="modal-<?php global $post; echo $post->post_name; ?>Title" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <h3><?php the_title(); ?></h3>
                                                        <?php the_content(); ?>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                                </div>
                            </div>
                            <?php endif;
                            wp_reset_postdata();
                            ?>
                        </div>
                    </div>
                </div>

                <?php 
                // Case: Basic Page.
                elseif( get_row_layout() == 'basic_page' ):?>

                <?php if ( get_sub_field('text') ) : ?>
                <div class="container py-5">
                    <div class="row">
                        <div class="col-12">
                            <?php echo get_sub_field('text'); ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php 
                // Case: Contact Form Row.
                elseif( get_row_layout() == 'contact_form_row' ):?>
                
                <div class="bg_texture left-black-30">
                    <div class="container">
                       <div class="row">
                            <?php if ( get_sub_field('title') or get_sub_field('text') ) : ?>
                                <div class="col-12 col-lg-4 indent-text-white bg_black py-5 pr-lg-5">
                                    <div class="py-lg-5">
                                        <h1 class="mb-4"><?php echo get_sub_field('title'); ?></h1>
                                        <?php echo get_sub_field('text'); ?>
    
                                        <div class="pb-4">
                                            <?php 
                                            $link = get_field('phone', 'option');
                                            if( $link ): 
                                                $link_url = $link['url'];
                                                $link_title = $link['title'];
                                                $link_target = $link['target'] ? $link['target'] : '_self';
                                                ?>
                                                <div>
                                                    <a class="basic-link" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                                                </div>
                                            <?php endif; ?>
        
                                            <?php 
                                            $link = get_field('email', 'option');
                                            if( $link ): 
                                                $link_url = $link['url'];
                                                $link_title = $link['title'];
                                                $link_target = $link['target'] ? $link['target'] : '_self';
                                                ?>
                                                <div>
													<a class="basic-link" href="mailto:<?php echo antispambot( $link_title ) ?>"><?php echo antispambot( $link_title ) ?></a>
                                                </div>
                                            <?php endif; ?>
											
                                        </div>
    
                                        <p class="intro color_white opening-hours-contact"><?php echo get_field('opening_hours', 'option'); ?></p>
    
                                        <?php 
                                        $link = get_field('after_hours_phone', 'option');
                                        if( $link ): 
                                            $link_url = $link['url'];
                                            $link_title = $link['title'];
                                            $link_target = $link['target'] ? $link['target'] : '_self';
                                            ?>
                                            <a class="basic-link" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            <?php endif; ?>
                            <?php if ( get_sub_field('contact_form') ) : ?>
                                <div class="col-12 col-lg-8 pl-lg-4 py-5 pl-lg-5">
                                    <div class="py-lg-5">
                                        <?php echo get_sub_field('contact_form'); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif;
        endwhile; ?>
    <?php endif; ?>